//=============================================================================
// Maple.
//=============================================================================
class Maple_Bot extends HumanMilitary_Bot;

function Killed(pawn Killer, pawn Other, name damageType)
{
 Super(ScriptedPawn).Killed(Killer,Other,damageType);

if (Killer == None && Other == Self) return;


if ((Killer.IsA('DeusExPlayer')) && (Other == Self))
{
 if ((bGiveScore) && (DeusExPlayer(Killer).Alliance != Alliance))
  DeusExPlayer(Killer).PlayerReplicationInfo.Score += KillScore;
 if ((bGiveScore) && (DeusExPlayer(Killer).Alliance == Alliance))
  DeusExPlayer(Killer).PlayerReplicationInfo.Score -= KillScore;
 if ((bGiveDeathMessage) && (DeusExPlayer(Killer).InHand != None))
  BroadcastMessage(""$DeathMessageColor$""$DeusExPlayer(Killer).PlayerReplicationInfo.PlayerName$" incapacitated "$PawnsArticle$" "$PawnsName$" with "$DeusExPlayer(Killer).InHand.ItemArticle$" "$DeusExPlayer(Killer).InHand.ItemName$"!");
 else if ((bGiveDeathMessage) && (DeusExPlayer(Killer).InHand == None))
  BroadcastMessage(""$DeathMessageColor$""$DeusExPlayer(Killer).PlayerReplicationInfo.PlayerName$" incapacitated "$PawnsArticle$" "$PawnsName$" with 1337 ninja skills!");
}

}

function Carcass SpawnCarcass()
{
	local DeusExCarcass carc;
	local vector loc;
	local Inventory item, nextItem;
	local FleshFragment chunk;
	local int i;
	local float size;

	//DONT GIB, SHE ONLY GETS KNOCKED OUT FFS
	/*
	// if we really got blown up good, gib us and don't display a carcass
	if ((Health < -100) && !IsA('Robot'))
	{
		size = (CollisionRadius + CollisionHeight) / 2;
		if (size > 10.0)
		{
			for (i=0; i<size/4.0; i++)
			{
				loc.X = (1-2*FRand()) * CollisionRadius;
				loc.Y = (1-2*FRand()) * CollisionRadius;
				loc.Z = (1-2*FRand()) * CollisionHeight;
				loc += Location;
				chunk = spawn(class'FleshFragment', None,, loc);
				if (chunk != None)
				{
					chunk.DrawScale = size / 25;
					chunk.SetCollisionSize(chunk.CollisionRadius / chunk.DrawScale, chunk.CollisionHeight / chunk.DrawScale);
					chunk.bFixedRotationDir = True;
					chunk.RotationRate = RotRand(False);
				}
			}
		}

		return None;
	}*/

	// spawn the carcass
	carc = DeusExCarcass(Spawn(CarcassType));

	if ( carc != None )
	{
		if (bStunned)
			carc.bNotDead = True;

		carc.Initfor(self);

		// move it down to the floor
		loc = Location;
		loc.z -= Default.CollisionHeight;
		loc.z += carc.Default.CollisionHeight;
		carc.SetLocation(loc);
		carc.Velocity = Velocity;
		carc.Acceleration = Acceleration;

		// give the carcass the pawn's inventory if we aren't an animal or robot
		if (!IsA('Animal') && !IsA('Robot'))
		{
			if (Inventory != None)
			{
				do
				{
					item = Inventory;
					nextItem = item.Inventory;
					DeleteInventory(item);
					if ((DeusExWeapon(item) != None) && (DeusExWeapon(item).bNativeAttack))
						item.Destroy();
					else
						carc.AddInventory(item);
					item = nextItem;
				}
				until (item == None);
			}
		}
	}

	return carc;
}


defaultproperties
{
     AlertingSpeeches(2)="Gonna need a bigger gun!"
     CarcassType=Class'MapleBotCarcass'
     WalkingSpeed=0.320000
     bImportant=True
     bFearShot=False
     bFearIndirectInjury=False
     bFearCarcass=False
     bFearDistress=False
     bReactFutz=True
     Alliance=Markistan
     InitialAlliances(0)=(AllianceName=Player,AllianceLevel=1.000000,bPermanent=True)
     BaseAssHeight=-18.000000
     InitialInventory(0)=(Inventory=Class'MSCWeaponM16')
     InitialInventory(1)=(Inventory=Class'MSCAmmo556mm',Count=300)
     InitialInventory(2)=(Inventory=Class'MSCWeaponDeagle')
     InitialInventory(3)=(Inventory=Class'MSCAmmo50Cal',Count=150)
     walkAnimMult=0.650000
     bIsFemale=True
     BaseEyeHeight=38.000000
     Health=1000
     HealthArmLeft=750
     HealthArmRight=750
     HealthHead=750
     HealthLegLeft=750
     HealthLegRight=750
     HealthTorso=750
     AttitudeToPlayer=ATTITUDE_Follow
     Mesh=LodMesh'DeusExCharacters.GFM_Dress'
     MultiSkins(0)=Texture'Markistan.Skins.MapleTex0'
     MultiSkins(1)=Texture'Markistan.Skins.MapleTex3'
     MultiSkins(2)=Texture'Markistan.Skins.MapleTex2'
     MultiSkins(3)=Texture'Markistan.Skins.MapleTex1'
     MultiSkins(4)=Texture'Markistan.Skins.MapleTex2'
     MultiSkins(5)=Texture'DeusExItems.Skins.PinkMaskTex'
     MultiSkins(6)=Texture'DeusExItems.Skins.PinkMaskTex'
     MultiSkins(7)=Texture'Markistan.Skins.MapleTex0'
     CollisionRadius=20.000000
     CollisionHeight=43.000000
     BindName="Maple"
     FamiliarName="Maple"
     UnfamiliarName="Woman"
     PawnsName="Maple"
}
